package com.xxfc.platform.vehicle.common;

import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.context.BaseContextHandler;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletRequest;

@Slf4j
public class BaseController<Biz extends BaseBiz> {
    @Autowired
    protected HttpServletRequest request;
    @Autowired
    protected Biz baseBiz;

    public HttpServletRequest getRequest() {
        return request;
    }

    public String getCurrentUserName(){
        return BaseContextHandler.getUsername();
    }

    public String getCurrentUserId(){
        return BaseContextHandler.getUserID();
    }

    public Integer getCurrentUserIdInt(){
        if(null != BaseContextHandler.getUserID()) {
            return Integer.valueOf(BaseContextHandler.getUserID());
        }else {
            return null;
        }
    }
}
