package com.xxfc.platform.vehicle.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2020-09-19 17:48:20
 */
@Data
@Table(name = "vehicle_category")
public class VehicleCategory implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("")
    private Integer id;
	
	    /**
     *  
     */
    @Column(name = "brand_id")
	@ApiModelProperty(value = "")
    private Integer brandId;
	
	    /**
     *  
     */
    @Column(name = "brand_name")
	@ApiModelProperty(value = "")
    private String brandName;
	
	    /**
     *  
     */
    @Column(name = "name")
	@ApiModelProperty(value = "")
    private String name;
	
	    /**
     *  
     */
    @Column(name = "stock")
	@ApiModelProperty(value = "")
    private Integer stock;
	
	    /**
     *  品牌删除状态 1：上架 2：下架
     */
    @Column(name = "shelves")
	@ApiModelProperty(value = "品牌删除状态 1：上架 2：下架")
    private Integer shelves;
	
	    /**
     *  品牌删除状态 1：正常 2：删除
     */
    @Column(name = "is_del")
	@ApiModelProperty(value = "品牌删除状态 0：正常 1：删除")
    private Integer isDel;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Date crtTime;
	
	    /**
     *  修改时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "修改时间", hidden = true )
    private Date updTime;

	/**
	 *  商品类型 1--房车；2--机车；3--游艇
	 */
	@Column(name = "goods_type")
	@ApiModelProperty(value = "商品类型 1--房车；2--机车；3--游艇")
	private Integer goodsType;



	/**
	 *  封面图
	 */
	@Column(name = "banner")
	@ApiModelProperty(value = "封面图")
	private String banner;



	/**
	 *  轮播图
	 */
	@Column(name = "carousel")
	@ApiModelProperty(value = "轮播图")
	private String carousel;
}
