package com.xxfc.platform.app.rest.admin;

import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.admin.feign.rest.UserRestInterface;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.app.biz.BannerBiz;
import com.xxfc.platform.app.entity.Banner;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


/**
 * @author libin
 * @version 1.0
 * @description banner 图
 * @data 2019/6/12 21:15
 */
@RestController
@RequestMapping("/admin/banner")
@Api(value = "banner后台接口", tags = "banner后台接口")
public class BannerAdminController implements UserRestInterface {

    @Autowired
    private BannerBiz bannerBiz;

    @Autowired
    private UserFeign userFeign;

    @Override
    public UserFeign getUserFeign() {
        return userFeign;
    }

    /**
     * 修改
     *
     * @param banner
     * @return
     */
    @PutMapping
    @ApiOperation(value = "banner修改", notes = "修改")
    public ObjectRestResponse<Banner> update(@RequestBody Banner banner, UserDTO userInfo) {
        userInfo = getAdminUserInfo();
        int effectRows = bannerBiz.save(banner, userInfo);
        if (effectRows > 0) {
            return ObjectRestResponse.succ();
        }
        return ObjectRestResponse.createDefaultFail();
    }

    /**
     * 根据id查询banner
     *
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询banner图", notes = "根据id查询banner图")
    public ObjectRestResponse<Banner> findBannerById(@PathVariable Integer id) {
        Banner Banner = bannerBiz.selectById(id);
        return ObjectRestResponse.succ(Banner);
    }

    /**
     * 分页查询banner
     *
     * @param pageNo
     * @param pageSize
     * @return
     */
    @GetMapping("/page")
    @ApiOperation(value = "banner分页查询", notes = "banner分页查询")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "pageNo", paramType = "query", required = false, dataType = "integer", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", paramType = "query", required = false, dataType = "integer", defaultValue = "10")
    })
    public ObjectRestResponse<PageDataVO> findBannerPage(@RequestParam(name = "pageNo", defaultValue = "0", required = false) Integer pageNo,
                                                         @RequestParam(name = "pageSize", defaultValue = "10", required = false) Integer pageSize,
                                                         @RequestParam(name = "status", required = false) Integer status,
                                                         @RequestParam(name = "location", required = false) Integer location,
                                                         @RequestParam(name = "platform", defaultValue = "0", required = false) Integer platform) {

        PageDataVO<Banner> pageDataVO = bannerBiz.findBannePage(pageNo, pageSize, platform, status, location);

        return ObjectRestResponse.succ(pageDataVO);
    }

    /**
     * 保存banner
     *
     * @param banner
     * @return
     */
    @ApiOperation(value = "banner保存", notes = "banner保存")
    @PostMapping
    public ObjectRestResponse<Void> saveBanner(@RequestBody Banner banner, UserDTO userDTO) {
        userDTO = getAdminUserInfo();
        banner.setIsDel(0);
        int effectRows = bannerBiz.save(banner, userDTO);
        if (effectRows > 0) {
            return ObjectRestResponse.succ();
        }
        return ObjectRestResponse.createDefaultFail();

    }

    /**
     * 逻辑删除
     *
     * @param id
     * @return
     */
    @DeleteMapping("/{id}")
    @ApiOperation(value = "banner逻辑删除", notes = "banner逻辑删除")
    public ObjectRestResponse<Void> deleteBannerById(@PathVariable Integer id, UserDTO userDTO) {
        int effectRows = bannerBiz.updateBannerStatus(id, 1, userDTO);
        if (effectRows > 0) {
            return ObjectRestResponse.succ();
        }
        return ObjectRestResponse.createDefaultFail();
    }

    /**
     * 真实删除
     *
     * @param id
     * @return
     */
    @DeleteMapping("/del/{id}")
    public ObjectRestResponse<Void> deleteReallyBannerById(@PathVariable(value = "id") Integer id) {
        bannerBiz.deleteById(id);
        return ObjectRestResponse.succ();
    }

}