package com.xxfc.platform.activity.biz;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.activity.dto.ActivityDTO;
import com.xxfc.platform.activity.dto.ActivityLuckDrawFindDTO;
import com.xxfc.platform.activity.vo.ActivityLuckyDrawListVo;
import com.xxfc.platform.activity.vo.ActivityVo;
import org.springframework.stereotype.Service;

import com.xxfc.platform.activity.entity.Activity;
import com.xxfc.platform.activity.mapper.ActivityMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;

/**
 * 峰会活动表
 *
 * @author wuweizhi
 * @email 18178966185@163.com
 * @date 2020-10-08 09:48:35
 */
@Service
public class ActivityBiz extends BaseBiz<ActivityMapper, Activity> {

    public ObjectRestResponse<PageDataVO<ActivityVo>> getAllByPage(ActivityDTO activityDTO) {
        Integer page = activityDTO.getPage() == null ? 1 : activityDTO.getPage();
        Integer limit = activityDTO.getLimit() == null ? 10 : activityDTO.getLimit();
        activityDTO.setPage(page);
        activityDTO.setLimit(limit);
        Query query = new Query(activityDTO);
        PageDataVO<ActivityVo> pageDataVO = PageDataVO.pageInfo(query, () -> mapper.getAllByPage(query.getSuper()));
        return ObjectRestResponse.succ(pageDataVO);
    }
}