package com.xxfc.platform.activity.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 峰会活动表
 * 
 * @author wuweizhi
 * @email 18178966185@163.com
 * @date 2020-10-08 09:48:35
 */
@Data
@Table(name = "activity")
public class Activity implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("")
    private Integer id;
	
	    /**
     *  活动类型：1--房车；2--机车；3--游艇
     */
    @Column(name = "goods_type")
	@ApiModelProperty(value = "活动类型：1--房车；2--机车；3--游艇")
    private Integer goodsType;
	
	    /**
     *  开始时间
     */
    @Column(name = "start_time")
	@ApiModelProperty(value = "开始时间")
    private Long startTime;
	
	    /**
     *  结束时间
     */
    @Column(name = "end_time")
	@ApiModelProperty(value = "结束时间")
    private Long endTime;
	
	    /**
     *  报名截止时间（不展示）
     */
    @Column(name = "bm_close_time")
	@ApiModelProperty(value = "报名截止时间（不展示）")
    private Long bmCloseTime;
	
	    /**
     *  行程
     */
    @Column(name = "trip")
	@ApiModelProperty(value = "行程")
    private String trip;
	
	    /**
     *  省编码
     */
    @Column(name = "province_code")
	@ApiModelProperty(value = "省编码")
    private Integer provinceCode;
	
	    /**
     *  省
     */
    @Column(name = "province")
	@ApiModelProperty(value = "省")
    private String province;
	
	    /**
     *  市编码
     */
    @Column(name = "city_code")
	@ApiModelProperty(value = "市编码")
    private Integer cityCode;
	
	    /**
     *  市
     */
    @Column(name = "city")
	@ApiModelProperty(value = "市")
    private String city;
	
	    /**
     *  县/镇 编码
     */
    @Column(name = "town_code")
	@ApiModelProperty(value = "县/镇 编码")
    private Integer townCode;
	
	    /**
     *  县/镇
     */
    @Column(name = "town")
	@ApiModelProperty(value = "县/镇")
    private String town;
	
	    /**
     *  活动场地（地址格式）
     */
    @Column(name = "address")
	@ApiModelProperty(value = "活动场地（地址格式）")
    private String address;
	
	    /**
     *  纬度（不展示）
     */
    @Column(name = "latitude")
	@ApiModelProperty(value = "纬度（不展示）")
    private BigDecimal latitude;
	
	    /**
     *  经度 （不展示）
     */
    @Column(name = "longitude")
	@ApiModelProperty(value = "经度 （不展示）")
    private BigDecimal longitude;
	
	    /**
     *  活动图文内容(峰会主题)
     */
    @Column(name = "content")
	@ApiModelProperty(value = "活动图文内容(峰会主题)")
    private String content;
	
	    /**
     *  图片说明，逗号隔开
     */
    @Column(name = "imgs")
	@ApiModelProperty(value = "图片说明，逗号隔开")
    private String imgs;
	
	    /**
     *  是否允许打电话：1-是；2否
     */
    @Column(name = "is_call_tel")
	@ApiModelProperty(value = "是否允许打电话：1-是；2否")
    private Integer isCallTel;
	
	    /**
     *  活动状态：0-未审核；1-通过；2-驳回
     */
    @Column(name = "status")
	@ApiModelProperty(value = "活动状态：0-未审核；1-通过；2-驳回")
    private Integer status;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    /**
     *  创建人id
     */
    @Column(name = "ctr_user")
	@ApiModelProperty(value = "创建人id")
    private Integer ctrUser;
	
	    /**
     *  修改时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "修改时间", hidden = true )
    private Long updTime;
	
	    /**
     *  删除（0正常，1删除）
     */
    @Column(name = "is_del")
	@ApiModelProperty(value = "删除（0正常，1删除）")
    private Integer isDel;
	

}
