package com.github.wxiaoqi.security.admin.rest;


import com.github.wxiaoqi.security.admin.biz.UserCommentBiz;
import com.github.wxiaoqi.security.admin.dto.UserCommentFindDTO;
import com.github.wxiaoqi.security.admin.entity.UserComment;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author Administrator
 */
@Slf4j
@RestController
@RequestMapping("app/comment")
@Api(tags = {"评论"})
public class AppUserCommentController extends BaseController<UserCommentBiz> {







    @GetMapping("app/unauth/selectList")
    @ApiModelProperty("列表")
    @IgnoreUserToken
    public  ObjectRestResponse selectList(UserCommentFindDTO commentFindDTO) {
        return ObjectRestResponse.succ( baseBiz.selectList(commentFindDTO));
    }



    @PostMapping("send")
    @ApiModelProperty("商家入驻申请")
    public  ObjectRestResponse apply(@RequestBody UserComment userComment) {
        userComment.setUserId(getCurrentUserIdInt());
        baseBiz.addOrUpd(userComment);
        return ObjectRestResponse.succ();
    }



}
