package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.biz.*;

import com.github.wxiaoqi.security.admin.entity.CompanyInfo;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author Administrator
 */
@Slf4j
@RestController
@RequestMapping("app/company")
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
@Api(tags = {"商家入驻"})
public class AppCompanyInfoController extends BaseController<CompanyInfoApplyBiz> {


    @Autowired
    CompanyInfoOrderBiz companyInfoOrderBiz;


    @PostMapping("apply")
    @ApiModelProperty("商家入驻申请")
    public  ObjectRestResponse apply(@RequestBody CompanyInfo companyInfo) {
     companyInfo.setAppUserId(getCurrentUserIdInt());
     return ObjectRestResponse.succ(baseBiz.saveApply(companyInfo));
    }


    @GetMapping("order/{id}")
    @ApiModelProperty("商家入驻订单")
    public  ObjectRestResponse applySelectList(@PathVariable("id") Long id) {
        return ObjectRestResponse.succ( companyInfoOrderBiz.getList(id));
    }



}
