package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.biz.BranchCompanyBiz;
import com.github.wxiaoqi.security.admin.biz.CompanyInfoApplyBiz;
import com.github.wxiaoqi.security.admin.biz.CompanyInfoOrderBiz;
import com.github.wxiaoqi.security.admin.entity.CompanyInfo;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author Administrator
 */
@Slf4j
@RestController
@RequestMapping("app/branchCompany")
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
@Api(tags = {"商家"})
public class AppBranchCompanyController extends BaseController<CompanyInfoApplyBiz> {


    @Autowired
    BranchCompanyBiz branchCompanyBiz;


    @GetMapping("getHotCompany")
    @ApiModelProperty("获取热门商家")
    public  ObjectRestResponse getHotCompany(@RequestParam("page") Integer page,
                                             @RequestParam("limit") Integer limit) {
     return ObjectRestResponse.succ(branchCompanyBiz.getHotCompany(page,limit));
    }

}
