package com.github.wxiaoqi.security.admin.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 订单分账表
 * 
 * @author hezhen
 * @email 18178966185@163.com
 * @date 2020-03-03 13:13:34
 */
@Data
@Table(name = "base_order_accept_detailed")
public class BaseOrderAcceptDetailed implements Serializable {
	private static final long serialVersionUID = 1L;
	

    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键id")
    private Integer id;
	


    @Column(name = "mch_id")
	@ApiModelProperty(value = "分账账号")
    private Integer mchId;
	

    @Column(name = "order_no")
	@ApiModelProperty(value = "分账订单")
	private String orderNo;


	@Column(name = "order_id")
	@ApiModelProperty(value = "订单id")
	private Integer orderId;


	@Column(name = "user_id")
	@ApiModelProperty(value = "来源用户id")
	private Integer userId;



	@Column(name = "division_type")
	@ApiModelProperty(value = "类型 1=>平台抽成；2-上级用户拥金；3-上级商家拥金；4-推荐入驻拥金")
	private Integer divisionType;



	@Column(name = "division_amount")
	@ApiModelProperty(value = "分账金额")
	private BigDecimal divisionAmount;


	@Column(name = "fee")
	@ApiModelProperty(value = "手续费")
	private BigDecimal fee;



	@Column(name = "order_amount")
	@ApiModelProperty(value = "订单金额")
	private BigDecimal orderAmount;


	@Column(name = "status")
	@ApiModelProperty(value = "是否入账:0-未结算；1-已结算")
	private Integer status;



	@Column(name = "extract")
	@ApiModelProperty(value = "抽成比例")
	private Integer extract;



	@Column(name = "type")
	@ApiModelProperty(value = "类型：1-转入；2-退款")
	private Integer type;



	@Column(name = "add_time")
	@ApiModelProperty(value = "下单时间")
	private Long addTime;


	@Column(name = "status_time")
	@ApiModelProperty(value = "结算时间")
	private Long statusTime;


}
