package com.github.wxiaoqi.security.admin.entity;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.wxiaoqi.security.admin.dto.MemberLevelRightsDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.util.StringUtils;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;


/**
 * 会员等级设置
 * 
 * @author hezhen
 * @email 18178966185@163.com
 * @date 2020-06-24 09:12:21
 */
@Data
@Table(name = "base_member_level")
public class BaseMemberLevel implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  主键(也等值level级别(因级别变动))
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键(也等值level级别(因级别变动))")
    private Integer id;
	
	    /**
     *  等级名称(VIP1,VIP2,VIP3........),展示使用
     */
    @Column(name = "level")
	@ApiModelProperty(value = "等级名称(VIP1,VIP2,VIP3........),展示使用")
    private Integer level;
	
	    /**
     *  升级条件 0:充值 1：积分 2：注册自动升级  
     */
    @Column(name = "up_condition_type")
	@ApiModelProperty(value = "升级条件 0:充值 1：积分 2：注册自动升级  ")
    private Integer upConditionType;
	
	    /**
     *  充值类型 0：一次性充值 1:累计充值
     */
    @Column(name = "recharge_type")
	@ApiModelProperty(value = "充值类型 0：一次性充值 1:累计充值")
    private Integer rechargeType;
	
	    /**
     *  一次性充值|累积充值
     */
    @Column(name = "money")
	@ApiModelProperty(value = "一次性充值|累积充值")
    private BigDecimal money;
	
	    /**
     *  积分
     */
    @Column(name = "points")
	@ApiModelProperty(value = "积分")
    private Integer points;
	
	    /**
     *  
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "", hidden = true )
    private Long crtTime;
	
	    /**
     *  
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "", hidden = true )
    private Long updTime;

	
	    /**
     *  会员名称
     */
    @Column(name = "member_name")
	@ApiModelProperty(value = "会员名称")
    private String memberName;
	
	    /**
     *  是否删除 0：未删除 1：已删除
     */
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除 0：未删除 1：已删除")
    private Integer isDel;
	
	    /**
     *  图标
     */
    @Column(name = "icon")
	@ApiModelProperty(value = "图标")
    private String icon;
	
	    /**
     *  有效数；-1是永久有效
     */
    @Column(name = "end_date")
	@ApiModelProperty(value = "有效数；-1是永久有效")
    private Long endDate;
	
	    /**
     *  描述
     */
    @Column(name = "describes")
	@ApiModelProperty(value = "描述")
    private String describes;
	
	    /**
     *  权益
     */
    @Column(name = "rights")
	@ApiModelProperty(value = "权益")
    @JsonIgnore
    private String rights;

    @Transient
    private  Integer maxLevel;

    @Transient
    private List<MemberLevelRightsDTO> memberRights;


    @ApiModelProperty(value = "升级条件")
    @Transient
    private String upConditionStr;

    @ApiModelProperty(value = "折扣")
    @Transient
    private Integer discount;

    public List<MemberLevelRightsDTO> getMemberRights() {
        if(StringUtils.hasText(getRights())){
            List<MemberLevelRightsDTO> rightsDTOS= JSON.parseObject(getRights(),new TypeReference<List<MemberLevelRightsDTO>>(){});
            rightsDTOS=rightsDTOS.stream().sorted(Comparator.comparing(MemberLevelRightsDTO::getType)).collect(Collectors.toList());
            return  rightsDTOS;
        }
        return memberRights;
    }

    public Integer getDiscount(){
        discount=0;
        List<MemberLevelRightsDTO> rightsDTOS=getMemberRights();
        if (rightsDTOS != null && rightsDTOS.size() > 0){
            List<MemberLevelRightsDTO> rightsDTOList = rightsDTOS.stream().filter(x -> x.getType() == 0 && x.getStatus() == 1).collect(Collectors.toList());
            if (rightsDTOList != null && rightsDTOList.size() > 0){
                MemberLevelRightsDTO memberLevelRightsDTO = rightsDTOList.get(0);
                MemberLevelRightsDTO.MemberRights rights = memberLevelRightsDTO.getRights();
                if (rights != null ){
                    discount=rights.getDiscount();
                }
            }
        }
        return  discount;
    }


    public String getUpConditionStr(){
        upConditionStr="";
        if (getUpConditionType() != null){
            if (getUpConditionType() == 0){
                if (getRechargeType() != null && getRechargeType() == 0){
                    upConditionStr="一次性充值"+getMoney();
                }else if (getRechargeType() != null && getRechargeType() == 1){
                    upConditionStr="累计充值"+getMoney();
                }
            }else if (getUpConditionType() == 1){
                upConditionStr="积分满"+getPoints();
            }else if (getUpConditionType() == 2){
                upConditionStr="注册自动升级";
            }else if (getUpConditionType() == 3){
                upConditionStr="累计消费满"+getMoney();
            }
        }
        return upConditionStr;
    }

    public static void main(String[] args) {
        BaseUserMemberLevel memberLevel = new BaseUserMemberLevel();
        System.out.println(JSONUtil.wrap(memberLevel,false));
    }
}
