package com.github.wxiaoqi.security.admin.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 拥金比例设置表
 * 
 * @author zjw
 * @email 18178966185@163.com
 * @date 2019-07-11 18:34:39
 */
@Data
@Table(name = "base_commission_ratio")
public class BaseCommissionRatio implements Serializable {
	private static final long serialVersionUID = 1L;
	

    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键id")
    private Integer id;
	

    @Column(name = "type")
	@ApiModelProperty(value = "1-商户推荐人；2-上级；3-平台")
    private Integer type;
	


    @Column(name = "extract")
	@ApiModelProperty(value = "拥金比例")
    private Integer extract;


	@Column(name = "content")
	@ApiModelProperty(value = "拥金说明")
	private String content;


	@Column(name = "status")
	@ApiModelProperty(value = "状态：1-启用；2-禁止")
	private Integer status;
	

}
