package com.xxfc.platform.uccn.rest;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.CommonBaseController;
import com.xxfc.platform.tour.entity.TourTag;
import com.xxfc.platform.tour.feign.TourFeign;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

@RestController
@RequestMapping("app/unauth/tour")
@Slf4j
@IgnoreClientToken
public class GwTourController extends CommonBaseController {

    @Autowired
    TourFeign tourFeign;


    @ApiOperation("查询旅游路线列表")
    @RequestMapping(value = "/getGoodList", method = RequestMethod.GET)
    @IgnoreUserToken
    public ObjectRestResponse getGoodList(@RequestParam(value = "page", defaultValue = "1") Integer page,
                                          @RequestParam(value = "limit", defaultValue = "10") Integer limit,
                                          @RequestParam(value = "tagId", required = false) Integer tagId,
                                          @RequestParam(value = "name",required = false) String name) {
        return tourFeign.getGoodList(page, limit, tagId,name);
    }

    @GetMapping("/detail/{id}")
    @IgnoreUserToken
    public ObjectRestResponse getOne(@PathVariable Integer id) {
        return tourFeign.getOne(id);
    }

    @ApiOperation("首页旅游列表")
    @GetMapping(value = "/shopList")
    @IgnoreUserToken
    public ObjectRestResponse goodListAll(@RequestParam(value = "page", defaultValue = "1") Integer page,
                                          @RequestParam(value = "limit", defaultValue = "4") Integer limit) {
        return ObjectRestResponse.succ(tourFeign.goodListAll(page, limit));
    }

    @GetMapping("/tagList")
    @IgnoreUserToken
    public ObjectRestResponse getTagList(@RequestParam(value = "isHot", defaultValue = "0") Integer isHot) {
        List<TourTag> tourTags = tourFeign.tagList(isHot);
        tourTags = tourTags.stream().filter(x -> !x.getName().contains("全部")).sorted(Comparator.comparing(TourTag::getRank)).collect(Collectors.toList());
        return ObjectRestResponse.succ(tourTags);
    }

}
