package com.xxfc.platform.summit.controller;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.google.common.collect.Lists;
import com.xxfc.platform.summit.biz.ImsMeepoXianchangRidBiz;
import com.xxfc.platform.summit.entity.ImsMeepoXianchangRid;
import org.apache.commons.collections.CollectionUtils;
import org.mockito.internal.util.collections.ListUtil;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/imxr")
public class ImsMeepoXianchangRidController extends BaseController<ImsMeepoXianchangRidBiz, ImsMeepoXianchangRid> {
    @GetMapping("/ids")
    public ObjectRestResponse<List> getIds(@RequestParam(value = "page",defaultValue = "1")Integer page,
                                           @RequestParam(value = "limit",defaultValue = "10")Integer limit
                                           ){
        List<ImsMeepoXianchangRid> rids = baseBiz.getIds(page, limit);
        if (CollectionUtils.isEmpty(rids)) {
            return ObjectRestResponse.succ(Lists.newArrayList());
        }
        List<String> collect = rids.parallelStream().map(ImsMeepoXianchangRid::getId).collect(Collectors.toList());
        return ObjectRestResponse.succ(collect);
    }
}
