package com.xxfc.platform.order.rest.background;

import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.common.annotation.BeanValid;
import com.github.wxiaoqi.security.common.annotation.SimpleValid;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.order.biz.OrderReceivedStatisticsBiz;
import com.xxfc.platform.order.pojo.dto.OrderReceivedStatisticsFindDTO;
import com.xxfc.platform.order.pojo.vo.OrderReceivedStatisticsVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * @author libin
 * @version 1.0
 * @description 订单统计
 * @data 2019/11/11 9:14
 */
@Slf4j
@Api(tags = "订单统计")
@RestController
@RequestMapping("admin/order/received_statistics")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class OrderReceivedStatisticsAdminController {
    private final OrderReceivedStatisticsBiz orderReceivedStatisticsBiz;

     @ApiOperation("订单统计")
     @PostMapping("")
     public ObjectRestResponse<Map<String, List<OrderReceivedStatisticsVo>>> orderReceivedStatistics(@RequestBody @SimpleValid OrderReceivedStatisticsFindDTO orderReceivedStatisticsFindDTO, UserDTO userDTO){
         orderReceivedStatisticsFindDTO.setCompanyId(Arrays.asList(userDTO.getCompanyId()));
         Map<String, List<OrderReceivedStatisticsVo>> orderReceivedStatisticsPageVo = orderReceivedStatisticsBiz.getOrderReceivedStatisticsResult(orderReceivedStatisticsFindDTO);
         return ObjectRestResponse.succ(orderReceivedStatisticsPageVo);
     }

    @ApiOperation("订单统计excel导出下载")
    @PostMapping(value = "/export",consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ObjectRestResponse<Void> exportOrderReceivedStatistics(@RequestBody @BeanValid OrderReceivedStatisticsFindDTO orderReceivedStatisticsFindDTO,UserDTO userDTO, HttpServletResponse response){
        try {
            orderReceivedStatisticsFindDTO.setCompanyId(Arrays.asList(userDTO.getCompanyId()));
            String name = DateTimeFormatter.ofPattern("YYYYMMddHHmmss").format(LocalDateTime.now());
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            String filename = String.format("%s-OrderReceivedStatistics.xlsx",name);
            response.setHeader("Content-Disposition","attachment;filename="+ new String(filename.getBytes(), "iso8859-1"));
            ServletOutputStream outputStream = response.getOutputStream();
            orderReceivedStatisticsBiz.exportOrderReceivedStatisticsData(orderReceivedStatisticsFindDTO,outputStream);
            response.setCharacterEncoding("UTF-8");
            return ObjectRestResponse.succ();
        }catch (Exception ex){
             log.error("导出数据失败【{}】",ex);
            throw  new BaseException("导出数据失败");
        }
    }
}
