package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.biz.AppStaffUserBiz;
import com.github.wxiaoqi.security.admin.entity.AppStaffUser;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Administrator
 */
@RestController
@RequestMapping("/staff")
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
@Api(tags = {"员工客户管理"})
public class AppStaffUserController extends BaseController<AppStaffUserBiz, AppStaffUser> {
    private final UserAuthConfig authConfig;
    private final HttpServletRequest request;
    private final PublicController publicController;
    private final String POSITION_NAME="员工";

    /**
     * 获取该用户所用的客户
     * @return
     * @throws Exception
     */
    @Override
    @GetMapping("/all")
    public  List<AppStaffUser> all() throws Exception {
        AppUserDTO userDTO = (AppUserDTO) publicController.userDetailByToken(authConfig.getToken(request)).getData();
        if (POSITION_NAME.equals(userDTO.getPositionName())) {
         return baseBiz.getAll(userDTO.getUserid()) ;
        }
     return new ArrayList<>();
    }

    @Override
    @ApiOperation("添加")
    @PostMapping(value = "")
    public ObjectRestResponse<AppStaffUser> add(@RequestBody AppStaffUser appStaffUser) throws Exception {
        AppUserDTO userDTO = (AppUserDTO) publicController.userDetailByToken(authConfig.getToken(request)).getData();
        appStaffUser.setSuId(userDTO.getUserid());
        baseBiz.insertSelective(appStaffUser);
        return new ObjectRestResponse<AppStaffUser>();
    }

    @ApiOperation("查询一条")
    @GetMapping(value = "one")
    public ObjectRestResponse<AppStaffUser> findOne(AppStaffUser appStaffUser)  {
        AppStaffUser staffUser = baseBiz.findOne(appStaffUser);

        if (staffUser!=null) {
            return ObjectRestResponse.succ(staffUser);
        }
        return ObjectRestResponse.succ();
    }

    @ApiOperation("删除")
    @DeleteMapping(value = "delete/{id}")
    public ObjectRestResponse<AppStaffUser> delete(@PathVariable Integer id)  {
        AppStaffUser staffUser = new AppStaffUser();
        staffUser.setId(id);
        staffUser.setIsDel(1);
        baseBiz.updateSelectiveById(staffUser);
        return ObjectRestResponse.succ();
    }

}
