package com.xxfc.platform.vehicle.pojo.dto.order;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.xxfc.platform.vehicle.pojo.dto.VehicleModelCalendarPriceDTO;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class VMCalendarPriceCostDTO extends VehicleModelCalendarPriceDTO {

    @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd")
    private Date date;

    /**
     * 消费金额
     */
    private BigDecimal consumeAmount = BigDecimal.ZERO;

    /**
     * 免费金额
     */
    private BigDecimal freeAmount = BigDecimal.ZERO;

    public void setFreeAndConsumeAmount(BigDecimal realAmount, BigDecimal freeAmount) {
        setFreeAmount(freeAmount);
        setConsumeAmount(realAmount.subtract(freeAmount));
    }
}
