package com.xxfc.platform.uccn.rest.admin;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.uccn.biz.SEOBiz;
import com.xxfc.platform.uccn.entity.SEO;
import com.xxfc.platform.uccn.vo.SEOQuery;
import com.xxfc.platform.uccn.vo.SEOVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

/**
 * @author Administrator
 */
@RestController
@RequestMapping("seoBackground")
@Api(tags={"seo后台管理类"})
public class SEOBackgroundController extends BaseController<SEOBiz, SEO> {

    @PostMapping("/list")
    @ApiOperation(value = "查询模块列表")
    public ObjectRestResponse findList(@RequestBody SEOQuery query){
       return ObjectRestResponse.succ(baseBiz.getList(query));
    }

    @PutMapping("/upd")
    @ApiOperation(value = "修改模块")
    public ObjectRestResponse update(@RequestBody  SEOVo seoVo){
        boolean result = baseBiz.update(seoVo);
        if (result) {
            return ObjectRestResponse.succ();
        }
        return ObjectRestResponse.createDefaultFail() ;
    }


}
