package com.xxfc.platform.uccn.rest;

import com.github.wxiaoqi.security.admin.entity.BaseUserMemberLevel;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/10/17 9:37
 */
@RestController
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
@RequestMapping("/member_level/app/unauth")
public class MemberLevelController {

     private final UserFeign userFeign;
     @GetMapping("/list")
     public ObjectRestResponse<BaseUserMemberLevel> listMemberLevels(){
          List<BaseUserMemberLevel> levels = userFeign.levels();
          return ObjectRestResponse.succ(levels);
     }
}
