package com.xxfc.platform.tour.rest.officialWebsite;


import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.tour.biz.TourGoodBiz;
import com.xxfc.platform.tour.comstnt.WebsiteTourType;
import com.xxfc.platform.tour.entity.TourGood;
import com.xxfc.platform.tour.entity.WebsiteQuery;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.*;


@RestController
@RequestMapping("website")
@IgnoreClientToken
@IgnoreUserToken
@Api(tags = {"官网"})
public class OfficialWebsiteTourController extends BaseController<TourGoodBiz, TourGood> {

    @PostMapping("/app/unauth/tour")
    public ObjectRestResponse homePageTour(@RequestBody WebsiteQuery query) throws Exception {
        return ObjectRestResponse.succ(baseBiz.homePageTour(query));
    }


    @GetMapping("/app/unauth/tour/new")
    public ObjectRestResponse newTour(@RequestParam(value = "limit", defaultValue = "6") Integer limit) {
        return ObjectRestResponse.succ(baseBiz.newTour(limit));
    }

}