package com.xxfc.platform.order.rest.background;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.CommonBaseController;
import com.xxfc.platform.order.biz.TotalPerformanceBiz;
import com.xxfc.platform.order.pojo.QueryCriteria;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 总业绩报表
 * @author Administrator
 */

@RestController()
@RequestMapping("/reportForm")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class TotalPerformanceStatementController extends CommonBaseController {
     private final TotalPerformanceBiz totalPerformanceBiz;

    @RequestMapping()
    public ObjectRestResponse statisticalData(QueryCriteria queryCriteria){
        totalPerformanceBiz.statisticalData(queryCriteria);
    }
}
