package com.xxfc.platform.order.biz;

import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.order.entity.DailyOrderStatistics;
import com.xxfc.platform.order.mapper.DailyOrderStatisticsMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

/**
 * 每日租车订单统计和保存
 * @author Administrator
 */
@Slf4j
@Service
public class DailyOrderStatisticsBiz extends BaseBiz<DailyOrderStatisticsMapper, DailyOrderStatistics> {

    @Autowired
    private  DailyVehicleOrderStatisticsBiz vehicleStatisticsBiz;

    @Autowired
    private DailyTravelOrderStatisticsBiz travelStatisticsBiz;

    @Autowired
    private DailyMembersOrderStatisticsBiz membersStatisticsBiz;

    public boolean statisticalOrder(Integer day){
        boolean vehicleFlag = vehicleStatisticsBiz.dailyVehicleOrderRecord(day);
        boolean travelFlag = travelStatisticsBiz.dailyTravelOrderRecord(day);
        boolean membersFlag= membersStatisticsBiz.dailyMembersOrderRecord(day);
        if (vehicleFlag&&travelFlag&&membersFlag){

            log.info("----statisticalOrder:成功-----");
            return true;
        }
        log.info("statisticalOrder:失败!(vehicleFlag="+vehicleFlag+"/travelFlag="+travelFlag+"membersFlag="+membersFlag+")");
        return false;
    }

}
