package com.xxfc.platform.common.msg;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/9 17:55
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class BaseApiResult<T> implements Serializable {
    private static final long serialVersionUID = 1L;
    protected long code;
    protected String msg;
    protected T data;
    protected boolean successResponse;
    protected String requestId;

    public static <T> BaseApiResult<T> fail() {
        return new BaseApiResult(400, "fail", "fail", false, "0");
    }
    public static <T> BaseApiResult<T> fail(String msg) {
        return new BaseApiResult(400, msg, "fail", false, "0");
    }
    public static <T> BaseApiResult<T> fail(long code, String msg) {
        return new BaseApiResult(code, msg, "fail", false, "0");
    }


}
