package com.xxfc.platform.im.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.im.biz.ImCommentBiz;
import com.xxfc.platform.im.entity.ImComment;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping(value = "imComment")
@Api(value = "评论")
public class ImCommentController {

    @Autowired
    ImCommentBiz imCommentBiz;

    @PostMapping(value = "/add")
    @ApiOperation(value = "添加评论")
    public ObjectRestResponse add(@RequestBody ImComment imComment) {
        return imCommentBiz.add(imComment);
    }

    @DeleteMapping(value = "/delete")
    @ApiOperation(value = "删除评论")
    public ObjectRestResponse deleteById(ImComment imComment) {
        return imCommentBiz.deleteById(imComment);
    }
}
