package com.xxfc.platform.app.rest;

import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.rest.UserRestInterface;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.app.biz.BuyVehicleFormBiz;
import com.xxfc.platform.app.entity.BuyVehicleForm;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("buyVehicleForm")

public class BuyVehicleFormController extends BaseController<BuyVehicleFormBiz,BuyVehicleForm> implements UserRestInterface {

    @Autowired
    UserFeign userFeign;

    @Override
    public UserFeign getUserFeign() {
        return userFeign;
    }

    @ApiOperation("添加表单")
    @RequestMapping(value = "form-add",method = RequestMethod.POST)
    @IgnoreClientToken
    @ResponseBody
    public ObjectRestResponse<BuyVehicleForm> formAdd(@RequestBody BuyVehicleForm entity){
        checkAppUser();
        entity.setUserId(getAppUser().getUserid());
        baseBiz.insertSelective(entity);
        return ObjectRestResponse.succ();
    }
}