package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.biz.MyWalletBiz;
import com.github.wxiaoqi.security.admin.vo.AppletWalletVo;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.auth.client.jwt.UserAuthUtil;
import com.github.wxiaoqi.security.auth.common.util.jwt.IJWTInfo;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/12 9:17
 */
@RestController
@RequestMapping("/wallet")
public class MyWalletController {


    @Autowired
    private UserAuthUtil userAuthUtil;

    @Autowired
    private UserAuthConfig userAuthConfig;

    @Autowired
    private MyWalletBiz myWalletBiz;

     @GetMapping
    public ObjectRestResponse<AppletWalletVo> findMyWallet(HttpServletRequest request){
         try {
             IJWTInfo infoFromToken = userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request));
             AppletWalletVo wallet = myWalletBiz.findMyWallet(Integer.valueOf(infoFromToken.getId()));
             return ObjectRestResponse.succ(wallet);
         } catch (Exception e) {
             throw new BaseException(e);
         }

     }

}
