package com.github.wxiaoqi.security.admin.config;

import org.springframework.amqp.core.*;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;
import java.util.Map;

/**
 * rabbitmq配置类
 * 包含： 不知道什么orderWater队列
 * @author zhoujw
 * @date 2019/7/15
 */
@Configuration
public class RabbitConfig {

    public static final String HZ_EXC = "hz_exchange";
    public static final String ORDER_WATER_QUEUE = "orderWater_queue";
    public static final String ORDER_WATER_KEY = "order";

    /**
     * 队列交换机
     * 注意这里的交换机类型：CustomExchange 
     * @return
     */
    @Bean
    public DirectExchange directExchange(){
        return new DirectExchange(HZ_EXC, true, false);
    }

    /**
     * 队列
     * @return
     */
    @Bean
    public Queue orderWaterQueue(){
        return new Queue(ORDER_WATER_QUEUE,true);
    }

     /**
     * 队列绑定交换机
     * @return
     */
    @Bean
    public Binding orderWaterBinding(Queue orderWaterQueue, DirectExchange directExchange){
        return BindingBuilder.bind(orderWaterQueue).to(directExchange).with(ORDER_WATER_KEY);
    }

}

