package com.github.wxiaoqi.security.admin.biz;

import com.github.wxiaoqi.security.admin.entity.MyWalletDetail;
import com.github.wxiaoqi.security.admin.mapper.MyWalletDetailMapper;
import com.github.wxiaoqi.security.admin.vo.WalletDetailPageVo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

import java.util.ArrayList;
import java.util.List;


/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/12 9:18
 */
@Transactional
@Service
public class MyWalletDetailBiz extends BaseBiz<MyWalletDetailMapper, MyWalletDetail> {


 public PageDataVO<WalletDetailPageVo> findWalletDetailPage(Integer userId,Integer pageNo,Integer pageSize){

     PageDataVO<WalletDetailPageVo> walletDetailPageVo = new PageDataVO<>();
     Example example = new Example(MyWalletDetail.class);
     Example.Criteria criteria = example.createCriteria();
     criteria.andEqualTo("userId",userId);

     PageDataVO<MyWalletDetail> walletDetailPageVoPageDataVO = PageDataVO.pageInfo(pageNo, pageSize, () -> mapper.selectByExample(example));
     List<MyWalletDetail> walletDetails = walletDetailPageVoPageDataVO.getData();
     if (CollectionUtils.isEmpty(walletDetails)){
         return walletDetailPageVo;
     }
     List<WalletDetailPageVo> walletDetailPageVoList = new ArrayList<>();
     WalletDetailPageVo walletDetail;
     for (MyWalletDetail walletDetailPage : walletDetails) {
         walletDetail = new WalletDetailPageVo();
         BeanUtils.copyProperties(walletDetailPage,walletDetail);
         walletDetailPageVoList.add(walletDetail);
     }
     walletDetailPageVo.setTotalPage(walletDetailPageVoPageDataVO.getTotalPage());
     walletDetailPageVo.setTotalCount(walletDetailPageVoPageDataVO.getTotalCount());
     walletDetailPageVo.setPageSize(walletDetailPageVoPageDataVO.getPageSize());
     walletDetailPageVo.setPageNum(walletDetailPageVoPageDataVO.getPageNum());
     walletDetailPageVo.setData(walletDetailPageVoList);
     return walletDetailPageVo;
 }

}
