package com.github.wxiaoqi.security.admin.biz;

import com.github.wxiaoqi.security.admin.dto.WalletFindDTO;
import com.github.wxiaoqi.security.admin.dto.WalletListDTO;
import com.github.wxiaoqi.security.admin.entity.MyWallet;
import com.github.wxiaoqi.security.admin.mapper.MyWalletMapper;
import com.github.wxiaoqi.security.admin.vo.AppletWalletVo;
import com.github.wxiaoqi.security.admin.vo.WalletPageVo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.entity.Example;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/12 9:18
 */
@Transactional
@Service
public class MyWalletBiz extends BaseBiz<MyWalletMapper, MyWallet> {


    public AppletWalletVo findMyWallet(Integer userId) {

        AppletWalletVo appletWalletVo = new AppletWalletVo();

        Example example = new Example(MyWallet.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("userId", userId);
        List<MyWallet> wallets = mapper.selectByExample(example);

        MyWallet myWallet = wallets.get(0);
        BeanUtils.copyProperties(myWallet, appletWalletVo);
        return appletWalletVo;
    }

    public PageDataVO<WalletPageVo> listWalletWithPage(WalletFindDTO walletFindDTO) {

         PageDataVO<WalletPageVo> walletPageVo = new PageDataVO<>();
        PageDataVO<WalletListDTO> walletPage = PageDataVO.pageInfo(walletFindDTO.getPage(), walletFindDTO.getLimit(), () -> mapper.selectByPhoneOrUserName(walletFindDTO.getPhone(), walletFindDTO.getUsername()));
        List<WalletListDTO> wallets = walletPage.getData();
        if(CollectionUtils.isEmpty(wallets)){
            return walletPageVo;
        }

        List<WalletPageVo> walletPageVos = new ArrayList<>();
        WalletPageVo walletpg ;
        for (WalletListDTO wallet : wallets) {
            walletpg = new WalletPageVo();
            BeanUtils.copyProperties(wallet,walletpg);
            walletpg.setUsername(StringUtils.isEmpty(wallet.getRealname())?wallet.getNickname():wallet.getRealname());
            walletpg.setPhone(wallet.getUsername());
            walletPageVos.add(walletpg);
        }
        walletPageVos.sort(Comparator.comparing(WalletPageVo::getTotalAmount).reversed());
        walletPageVo.setPageNum(walletFindDTO.getPage());
        walletPageVo.setPageSize(walletFindDTO.getLimit());
        walletPageVo.setTotalCount(walletPage.getTotalCount());
        walletPageVo.setTotalPage(walletPage.getTotalPage());
        walletPageVo.setData(walletPageVos);
        return walletPageVo;
    }
}
