package com.xxfc.platform.order.pojo.price;

import lombok.Data;

import java.math.BigDecimal;

@Data
public class CancelStartedVO extends CostDetailExtend {
    /**
     * 消费金额（实际计费）
     */
    private BigDecimal consumeAmount = BigDecimal.ZERO;

    /**
     * 租车单价
     */
    private BigDecimal modelAmount = BigDecimal.ZERO;

    /**
     * 使用天数
     */
    private Integer usedDayNum = 0;

    /**
     * 使用金额
     */
    private BigDecimal usedAmount = BigDecimal.ZERO;

    /**
     * 使用免费天数
     */
    private Integer usedfreeDayNum = 0;

    /**
     * 使用免费金额
     */
    private BigDecimal usedFreeAmount = BigDecimal.ZERO;

    /**
     * 违约金描述
     */
    private String violateDesc;

    /**
     * 违约金金额
     */
    private BigDecimal violateAmount = BigDecimal.ZERO;

    /**
     * 优惠金额
     */
    private BigDecimal couponAmount = BigDecimal.ZERO;

    /**
     * 优惠描述
     */
    private String couponDesc;

    /**
     * 原订单是否包含优惠券
     */
    private Boolean hadConpon = Boolean.FALSE;

    /**
     * 赔偿金
     */
    private BigDecimal damagesAmount = BigDecimal.ZERO;
}
