package com.github.wxiaoqi.security.admin.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/18 9:50
 */
@Data
public class WalletDetailListDTO {

    private Integer id;

    private String username;

    private String nickname;

    private String realname;

    private String phone;

    @ApiModelProperty(value = "来源：0-活动，1-佣金，2-会员充值，10-提现，11-转账，12-购买")
    private Integer source;

    @ApiModelProperty("佣金商品名称")
    private String title;

    @ApiModelProperty("商品价格")
    private BigDecimal price;

    @ApiModelProperty("提成比例")
    private Integer extract;

    @ApiModelProperty("入帐状态")
    private Integer waiting;

    @ApiModelProperty(value = "收入/支出的金额(分)")
    private BigDecimal amount;

    @ApiModelProperty(value = "活动id")
    private Integer activityId;

    @ApiModelProperty(value = "0 收入 1 支出")
    private Integer itype;

    @ApiModelProperty("活动名称")
    private String activityName;


    @ApiModelProperty(value = "第三方单号")
    private Integer cono;
    
    @ApiModelProperty(value = "提现单号")
    private String withDrawOrderNo;

    @ApiModelProperty(value = "操作时间", hidden = true )
    private Long crtTime;

    @ApiModelProperty(value = "订单号")
    private String orderNo;

    @ApiModelProperty(value = "来源人")
    private String sourceUserName;

}
