package com.xxfc.platform.vehicle.biz;

import com.alibaba.fastjson.JSON;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.google.common.collect.Lists;
import com.xxfc.platform.vehicle.entity.BranchCompanyVehicleCount;
import com.xxfc.platform.vehicle.entity.Vehicle;
import com.xxfc.platform.vehicle.mapper.VehicleMapper;
import com.xxfc.platform.vehicle.pojo.BranchCompanyVehicleCountVo;
import com.xxfc.platform.vehicle.pojo.ResultVehicleVo;
import com.xxfc.platform.vehicle.pojo.VehicleExcelVo;
import com.xxfc.platform.vehicle.pojo.VehiclePageQueryVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
@Slf4j
public class VehicleInformationDownloadBiz extends BaseBiz<VehicleMapper, Vehicle> {

    @Autowired
    private VehicleBiz vehicleBiz;

    @Autowired
    private BranchCompanyVehicleCountBiz branchCompanyVehicleCountBiz;

    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd");
    public static final DateTimeFormatter DEFAULT_DATE_TIME_FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss");


    public List getByPageNotAllData(VehiclePageQueryVo vehiclePageQueryVo, List<Integer> companyList) throws Exception {
        Map<String, Object> params = PropertyUtils.describe(vehiclePageQueryVo);
        //处理预定日期相关参数
        vehicleBiz.adjustBookedInfoParam(params, vehiclePageQueryVo);
        if (companyList != null && companyList.size() > 0) {
            params.put("companyList", companyList);
        } else {
            params.put("companyList", Arrays.asList(-1));
        }

        return  mapper.getByPageNotAllData(params);
    }

    public List getByPage(VehiclePageQueryVo vehiclePageQueryVo) throws Exception  {

        Map<String, Object> params = PropertyUtils.describe(vehiclePageQueryVo);
        //处理预定日期相关参数
        vehicleBiz.adjustBookedInfoParam(params, vehiclePageQueryVo);
        params.get("yearMonthAndParam");
        if (vehiclePageQueryVo.getModelId() == null) {
            params.remove("modelId");
        }
        return  mapper.getByPage(params);
    }
    //getResultVehicleVoList
    public List<ResultVehicleVo> getResultVehicleVoList(String vehiclePageQueryVoJson, UserDTO userDTO) {
        VehiclePageQueryVo vehiclePageQueryVo = new VehiclePageQueryVo();
        try {
            if (StringUtils.isNotBlank(vehiclePageQueryVoJson)){
                vehiclePageQueryVo = JSON.parseObject(vehiclePageQueryVoJson, VehiclePageQueryVo.class);
            }

                if (userDTO.getDataAll() == 2) {
                    List<Integer> companyList = vehicleBiz.dataCompany(userDTO.getDataZone(), userDTO.getDataCompany());
                 return  getByPageNotAllData(vehiclePageQueryVo, companyList);
                }

          return   getByPage(vehiclePageQueryVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return new ArrayList();
    }


    public List<VehicleExcelVo> getList(String vehiclePageQueryVoJson, UserDTO userDTO) throws Exception  {
        List<ResultVehicleVo> resultVehicleVoList = getResultVehicleVoList(vehiclePageQueryVoJson, userDTO);
        ArrayList<VehicleExcelVo> arrayList = Lists.newArrayList();
        resultVehicleVoList.parallelStream().forEach(result->{
            try {
                VehicleExcelVo vehicleExcelVo = new VehicleExcelVo();
                BeanUtilsBean.getInstance().copyProperties(vehicleExcelVo,result);
                arrayList.add(vehicleExcelVo);
            } catch (Exception e) {
                log.error(e.getMessage());
                log.error(e.getMessage(), e);
            }
        });
        return arrayList;

    }

    public List<BranchCompanyVehicleCountVo> getAllVehicleInfo() {
        Map<String, Object> map = new HashMap<>();
        map.put("", DateTime.now().toString(DEFAULT_DATE_TIME_FORMATTER));
        map.put("", DateTime.now().toString(DEFAULT_DATE_TIME_FORMATTER));
        return vehicleBiz.getAllVehicleInfo(map);
    }


    public void add(Map<String, Object> param) {
        List<BranchCompanyVehicleCountVo> branchCompanyVehicleCountVos = vehicleBiz.getAllVehicleInfo(param);
        branchCompanyVehicleCountVos.parallelStream().forEach(result->{
            try {
                BranchCompanyVehicleCount branchCompanyVehicleCount = new BranchCompanyVehicleCount();
                branchCompanyVehicleCount.setCompanyName(result.getParkBranchCompanyName());
                branchCompanyVehicleCount.setVehicleNum(result.getCount());
                DateTime dateTime = DateTime.now();
                String dateStr = dateTime.toString(DATE_TIME_FORMATTER);
                branchCompanyVehicleCount.setCountDate(DateTime.parse(dateStr).toDate());
                branchCompanyVehicleCountBiz.add(branchCompanyVehicleCount);
            } catch (Exception e) {
                log.error(e.getMessage(), e);
            }
        });
    }



}
