package com.xxfc.platform.vehicle.biz;

import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.vehicle.entity.BranchCompanyVehicleCount;
import com.xxfc.platform.vehicle.mapper.BranchCompanyVehicleCountMapper;
import com.xxfc.platform.vehicle.pojo.dto.BranchCompanyVehicleCountDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Calendar;

@Service
@Slf4j
public class BranchCompanyVehicleCountBiz extends BaseBiz<BranchCompanyVehicleCountMapper, BranchCompanyVehicleCount> {
	@Autowired
	VehicleInformationDownloadBiz vehicleInformationDownloadBiz;

	public ObjectRestResponse add(BranchCompanyVehicleCount branchCompanyVehicleCount) {
		if (branchCompanyVehicleCount == null) {
			return ObjectRestResponse.paramIsEmpty();
		}
		BranchCompanyVehicleCount oldValue = selectOne(branchCompanyVehicleCount);
		if (oldValue == null) {
			insertSelectiveRe(branchCompanyVehicleCount);
		}
		return ObjectRestResponse.succ();
	}

	public ObjectRestResponse<PageDataVO<BranchCompanyVehicleCount>> findAll(BranchCompanyVehicleCountDTO branchCompanyVehicleCountDTO) {
		Integer pageNo = branchCompanyVehicleCountDTO.getPage() == null ? 1 : branchCompanyVehicleCountDTO.getPage();
		Integer pageSize = branchCompanyVehicleCountDTO.getLimit() == null ? 10 : branchCompanyVehicleCountDTO.getLimit();
		Integer type = branchCompanyVehicleCountDTO.getType() == null ? 1 : branchCompanyVehicleCountDTO.getType();
		branchCompanyVehicleCountDTO.setPage(pageNo);
		branchCompanyVehicleCountDTO.setLimit(pageSize);
		branchCompanyVehicleCountDTO.setType(type);
		if (type == 1) {
			branchCompanyVehicleCountDTO.setDayNum(1);
		} else if (type == 2) {
			branchCompanyVehicleCountDTO.setDayNum(7);
		} else if (type == 3) {
			branchCompanyVehicleCountDTO.setDayNum(getCurrentMonthLastDay());
		}
		Query query = new Query(branchCompanyVehicleCountDTO);
		PageDataVO<BranchCompanyVehicleCount> pageDataVO = PageDataVO.pageInfo(query, () -> mapper.getAllByParam(query.getSuper()));
		return ObjectRestResponse.succ(pageDataVO);
	}

	public int getCurrentMonthLastDay() {
		Calendar a = Calendar.getInstance();
		a.set(Calendar.DATE, 1);//把日期设置为当月第一天
		a.roll(Calendar.DATE, -1);//日期回滚一天，也就是最后一天
		int maxDate = a.get(Calendar.DATE);
		return maxDate;
	}

}
