/*
 * Decompiled with CFR 0.152.
 */
package ytx.org.apache.http.impl.auth;

import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import ytx.org.apache.http.Header;
import ytx.org.apache.http.HttpRequest;
import ytx.org.apache.http.auth.AuthenticationException;
import ytx.org.apache.http.auth.Credentials;
import ytx.org.apache.http.impl.auth.GGSSchemeBase;
import ytx.org.apache.http.protocol.HttpContext;

public class KerberosScheme
extends GGSSchemeBase {
    private static final String KERBEROS_OID = "1.2.840.113554.1.2.2";

    public KerberosScheme(boolean stripPort) {
        super(stripPort);
    }

    public KerberosScheme() {
        super(false);
    }

    @Override
    public String getSchemeName() {
        return "Kerberos";
    }

    @Override
    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        return super.authenticate(credentials, request, context);
    }

    @Override
    protected byte[] generateToken(byte[] input, String authServer) throws GSSException {
        return this.generateGSSToken(input, new Oid(KERBEROS_OID), authServer);
    }

    @Override
    public String getParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name may not be null");
        }
        return null;
    }

    @Override
    public String getRealm() {
        return null;
    }

    @Override
    public boolean isConnectionBased() {
        return true;
    }
}

