package com.xxfc.platform.vehicle.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

@Data
@Table(name = "vehicle_user_reserve")
public class VehicleUserReserve {
    @Id
    @GeneratedValue(generator = "JDBC")
    @ApiModelProperty("主键id")
    private Integer id;

    @Column(name = "user_id")
    @ApiModelProperty("用户id")
    private Integer userId;

    @Column(name = "mode_id")
    @ApiModelProperty("车型id")
    private Integer modeId;


    @ApiModelProperty("预定姓名")
    private String name;


    @ApiModelProperty("电话")
    private String phone;


    @Column(name = "start_time")
    @ApiModelProperty("开始时间")
    private Long startTime;

    @Column(name = "end_time")
    @ApiModelProperty("结束时间")
    private Long endTime;


    @Column(name = "addr_province")
    @ApiModelProperty("地址-省/直辖市(编码)")
    private Integer addrProvince;

    @Column(name = "province_name")
    @ApiModelProperty("省名称")
    private String provinceName;

    @Column(name = "addr_city")
    @ApiModelProperty("市编号")
    private Integer addrCity;

    @Column(name = "city_name")
    @ApiModelProperty("市名称")
    private String cityName;


    @Column(name = "company_id")
    @ApiModelProperty("分公司id")
    private Integer companyId;


    @Column(name = "crt_time")
    @ApiModelProperty("创建时间")
    private Long crtTime;


    @Column(name = "upd_time")
    @ApiModelProperty("更新时间")
    private Long updTime;


    @ApiModelProperty("0-未处理；1-处理中;2-已处理")
    private Integer status;

    @Column(name = "is_del")
    @ApiModelProperty("是否删除：0-正常；1-删除")
    private Integer isDel;



}