package com.xxfc.platform.universal.controller;


import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.common.config.rabbit.RabbitConstant;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.universal.biz.MQServiceBiZ;
import com.xxfc.platform.universal.entity.IdInformation;
import com.xxfc.platform.universal.service.CertificationService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;


/**
 * 实名认证
 */
@RestController
@RequestMapping("certif")
@Slf4j
public class CertificationController {



    @Autowired
    private CertificationService certificationService;


    @Autowired
    private UserFeign userFeign;

    @Qualifier("applicationTaskExecutor")
    @Autowired
    private TaskExecutor executor;

    @Autowired
    MQServiceBiZ mqServiceBiZ;





    @PostMapping("/app/certificate")
    public ObjectRestResponse  certificate(@RequestBody IdInformation idInformation, HttpServletRequest request) {

        if (idInformation == null) {
            ObjectRestResponse.createDefaultFail();
        }



        String token = request.getHeader("Authorization");
        log.info("------token======"+token);
        if (StringUtils.isEmpty(token)) {
            ObjectRestResponse.createFailedResult(ResultCode.RSTOKEN_NULL_CODE,"token为空");
        }


        //获得用户信息
        ObjectRestResponse<AppUserDTO> appUserDTOObjectRestResponse= userFeign.userDetailByToken(token);
        log.info("----用户信息========="+appUserDTOObjectRestResponse.getData());

        if (appUserDTOObjectRestResponse==null||appUserDTOObjectRestResponse.getData()==null||appUserDTOObjectRestResponse.getData().getId()==0) {

             return ObjectRestResponse.createFailedResult(ResultCode.GET_APPUSER_FAILED_CODE,"获取用户失败");
        }

        AppUserDTO appUserDTO = appUserDTOObjectRestResponse.getData();


        idInformation.setUserLonginId(appUserDTO.getUserid());


        //获取用户认证信息
        ObjectRestResponse orr = userFeign.authentication(idInformation.getUserLonginId(), null,null, 0);

        if (orr==null) {
            return ObjectRestResponse.createFailedResult(ResultCode.GET_AUTH_INFO_FAILED_CODE,"获取用户认证信息失败");
        }

        if (!orr.getRel()){
            return orr;
        }

        Integer type = idInformation.getCertificateType();
        log.info("----type========="+type);
        try {
            if (type!=null&&type==0){
                ObjectRestResponse<Integer> result = certificationService.certificate(idInformation);
                if (result.getRel()) {
                    executor.execute(new Runnable() {
                        @Override
                        public void run() {
                            setIntegral(appUserDTO.getUserid(),result.getData());
                        }
                    });
                }
                return result ;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE,"错误");

    }

    private void setIntegral(Integer userid, Integer iId){
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("userId", userid);
        jsonObject.put("integralRuleCode", "CRETIFICATION");
        jsonObject.put("channelId", iId);
        mqServiceBiZ.sendMessage(RabbitConstant.INTEGRAL_TOPIC, RabbitConstant.INTEGRAL_ROUTING_KEY, jsonObject.toJSONString());
    }

}
