package com.xxfc.platform.tour.rest;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.tour.biz.TourGoodVerificationBiz;
import com.xxfc.platform.tour.entity.TourGoodVerification;
import com.xxfc.platform.tour.vo.TourGoodOrderFindVo;
import com.xxfc.platform.tour.vo.TourGoodOrderVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/tourGood/verfication")
@IgnoreClientToken
public class TourGoodVerificationController extends BaseController<TourGoodVerificationBiz, TourGoodVerification> {
    /**
     * 查询订单列表
     * @param tourGoodOrderFindVo
     * @return
     */
    @ApiOperation("订单列表的查询")
    @RequestMapping(value = "/orders", method = RequestMethod.POST)
    public PageDataVO<TourGoodOrderVo> findTourGoodOrders( @RequestBody TourGoodOrderFindVo tourGoodOrderFindVo){
        PageDataVO<TourGoodOrderVo> tourGoodOrderPageDataVo = getBaseBiz().findTourGoodOrdersPage(tourGoodOrderFindVo);
        return tourGoodOrderPageDataVo;
    }


    /**
     * 更新发车状态
     * @param verficationId
     * @return
     */
    @PutMapping("/status")
    @ApiOperation("更新发车状态")
    public ObjectRestResponse<Void> updateTourGoodVerificationStatus(@RequestParam("verficationId") Integer verficationId){
        int effectRows = getBaseBiz().updateTourGoodVerificationStatus(verficationId);
        if (effectRows>0){
            return ObjectRestResponse.succ();
        }
        return ObjectRestResponse.createDefaultFail();
    }


    /**
     * 更新总人数或上车人数
     * @param verficationId
     * @param properties
     * @return
     */
    @PutMapping("/personnums")
    @ApiOperation("更新总人数或上车人数")
    public ObjectRestResponse<Void> updateTourGoodPersonNum(
            @RequestParam("verficationId") Integer verficationId,
            @RequestParam("properties") String properties,
            @RequestParam(value = "number",defaultValue = "1") Integer number){
        int effectRows = getBaseBiz().updateTourGoodPersonNum(verficationId,properties,number);
            if (effectRows>0){
            return ObjectRestResponse.succ();
        }
        return ObjectRestResponse.createDefaultFail();
    }

    @GetMapping("/departure_status")
    public Integer selectDepartureStatusByVerificationId(@RequestParam(value = "verificationId") Integer verificationId){
        return baseBiz.selectDepartureStatusByVerificationId(verificationId);
    }
}