package com.xxfc.platform.tour.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 旅游商品规格价格表
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-06 11:41:51
 */
@Data
@Table(name = "tour_good_spe_price")
public class TourGoodSpePrice implements Serializable {
	private static final long serialVersionUID = 1L;

    @Id
	@GeneratedValue(generator = "JDBC")
    private Integer id;

	/**
	 * 商品id
	 */
	@Column(name = "good_id")
	@ApiModelProperty(value = "商品id")
    private Integer goodId;

	/**
	 * 	出行时间
	 */
    @Column(name = "start_time")
	@ApiModelProperty(value = "出行时间")
    private Date startTime;

	/**
	 * 	结束时间
	 */
    @Column(name = "end_time")
	@ApiModelProperty(value = "结束时间")
    private Date endTime;

	/**
	 * 	规格id
	 */
    @Column(name = "spe_id")
	@ApiModelProperty(value = "规格id")
    private String speId;

	/**
	 * 	价格
	 */
	@Column(name = "price")
	@ApiModelProperty(value = "价格")
    private BigDecimal price;

	/**
	 * 	儿童价格
	 */
    @Column(name = "child_price")
	@ApiModelProperty(value = "儿童价格")
    private BigDecimal childPrice;

	/**
	 * 	会员价格
	 */
    @Column(name = "member_price")
	@ApiModelProperty(value = "会员价格")
    private String memberPrice;

	/**
	 * 	库存
	 */
	@Column(name = "stock")
	@ApiModelProperty(value = "库存")
    private Integer stock;

	/**
	 * 	创建时间
	 */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;

	/**
	 * 	更新时间
	 */
	@Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;

	/**
	 * 	是否删除：0-正常；1-删除
	 */
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除：0-正常；1-删除")
    private Integer isDel;

}
