package com.xxfc.platform.order.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 旅游订单详情
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-15 17:11:08
 */
@Data
@Table(name = "order_tour_detail")
public class OrderTourDetail implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  主键
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键")
    private Integer id;
	
	    /**
     *  基础订单id
     */
    @Column(name = "order_id")
	@ApiModelProperty(value = "基础订单id")
    private Integer orderId;
	
	    /**
     *  名称
     */
    @Column(name = "name")
	@ApiModelProperty(value = "名称")
    private String name;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    /**
     *  更新时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	
	    /**
     *  开始时间
     */
    @Column(name = "start_time")
	@ApiModelProperty(value = "开始时间")
    private Long startTime;
	
	    /**
     *  结束时间
     */
    @Column(name = "end_time")
	@ApiModelProperty(value = "结束时间")
    private Long endTime;
	
	    /**
     *  天数
     */
    @Column(name = "day_num")
	@ApiModelProperty(value = "天数")
    private Integer dayNum;
	
	    /**
     *  出发地点
     */
    @Column(name = "start_addr")
	@ApiModelProperty(value = "出发地点")
    private String startAddr;
	
	    /**
     *  还车地点
     */
    @Column(name = "end_addr")
	@ApiModelProperty(value = "还车地点")
    private String endAddr;
	
	    /**
     *  出游乘客ids
     */
    @Column(name = "tour_user_ids")
	@ApiModelProperty(value = "出游乘客ids")
    private String tourUserIds;
	
	    /**
     *  成人人数
     */
    @Column(name = "adult_num")
	@ApiModelProperty(value = "成人人数")
    private Integer adultNum;
	
	    /**
     *  儿童人数
     */
    @Column(name = "child_num")
	@ApiModelProperty(value = "儿童人数")
    private Integer childNum;
	
	    /**
     *  出发公司Id
     */
    @Column(name = "start_company_id")
	@ApiModelProperty(value = "出发公司Id")
    private Integer startCompanyId;
	
	    /**
     *  费用明细
     */
    @Column(name = "cost_detail")
	@ApiModelProperty(value = "费用明细")
    private String costDetail;
	
	    /**
     *  商品id
     */
    @Column(name = "good_id")
	@ApiModelProperty(value = "商品id")
    private Integer goodId;
	
	    /**
     *  总人数
     */
    @Column(name = "total_number")
	@ApiModelProperty(value = "总人数")
    private Integer totalNumber;
	
	    /**
     *  规格ids
     */
    @Column(name = "spe_ids")
	@ApiModelProperty(value = "规格ids")
    private String speIds;
	
	    /**
     *  具体商品（商品项）id
     */
    @Column(name = "spe_price_id")
	@ApiModelProperty(value = "具体商品（商品项）id")
    private Integer spePriceId;
	
	    /**
     *  联系人
     */
    @Column(name = "contact_man")
	@ApiModelProperty(value = "联系人")
    private String contactMan;
	
	    /**
     *  联系电话
     */
    @Column(name = "contact_phone")
	@ApiModelProperty(value = "联系电话")
    private String contactPhone;
	
	    /**
     *  联系邮箱
     */
    @Column(name = "contact_email")
	@ApiModelProperty(value = "联系邮箱")
    private String contactEmail;
	
	    /**
     *  出发城市名称
     */
    @Column(name = "start_city_name")
	@ApiModelProperty(value = "出发城市名称")
    private String startCityName;
	
	    /**
     *  出发城市编号
     */
    @Column(name = "start_city")
	@ApiModelProperty(value = "出发城市编号")
    private Integer startCity;
	
	    /**
     *  核销id
     */
    @Column(name = "verification_id")
	@ApiModelProperty(value = "核销id")
    private Integer verificationId;
	
	    /**
     *  核销人
     */
    @Column(name = "verification_user")
	@ApiModelProperty(value = "核销人")
    private Integer verificationUser;
	
	    /**
     *  核销人名称
     */
    @Column(name = "verification_name")
	@ApiModelProperty(value = "核销人名称")
    private String verificationName;
	
	    /**
     *  核销人联系电话
     */
    @Column(name = "verification_phone")
	@ApiModelProperty(value = "核销人联系电话")
    private Integer verificationPhone;
	
	    /**
     *  核销时间
     */
    @Column(name = "verification_time")
	@ApiModelProperty(value = "核销时间")
    private Long verificationTime;
	
	    /**
     *  出发公司区域id
     */
    @Column(name = "start_zone_id")
	@ApiModelProperty(value = "出发公司区域id")
    private Integer startZoneId;

	@Column(name = "has_insure")
	@ApiModelProperty(value = "是否保险标记 1--要保险；0--不需要")
	Integer hasInsure;

	@Column(name = "site_id")
	@ApiModelProperty(value = "出发的站点id")
	private Integer siteId;

	@Column(name = "is_outside")
	@ApiModelProperty(value = "是否省外 1--省外；0--省内")
	private Integer isOutside;
}
