package com.xxfc.platform.activity.feign;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.activity.vo.UserCouponVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;


/**
 * ${DESCRIPTION}
 *
 * @author wanghaobin
 * @create 2017-06-21 8:11
 */
@FeignClient(value = "xx-activity")
public interface ActivityFeign {

    public static final Integer TYPE_USE = 1;
    public static final Integer TYPE_NO_USE = 0;


    @ApiOperation("用户自动领取新人卷")
    @RequestMapping(value = "/user/auth/led", method = RequestMethod.POST)
    public String led(@RequestParam(value = "userId") Integer userId);

    @ApiOperation("单个优惠卷信息")
    @RequestMapping(value = "/user/info/{no}", method = RequestMethod.GET)
    public UserCouponVo info(@PathVariable(value = "no") String no);

    @ApiOperation("优惠卷使用")
    @RequestMapping(value = "/user/use", method = RequestMethod.POST)
    public BigDecimal use(
            @RequestParam(value = "userId") Integer userId,
            @RequestParam(value = "tickerNo") String tickerNo,
            @RequestParam(value = "orderNo") String orderNo,
            @RequestParam(value = "channel") Integer channel,
            @RequestParam(value = "amount") BigDecimal amount,
            @RequestParam(value = "type") Integer type);

    @ApiOperation("优惠卷取消使用")
    @RequestMapping(value = "/user/cancelUse", method = RequestMethod.POST)
    public ObjectRestResponse cancelUse(@RequestParam(value = "TickerNo",defaultValue ="" ) String TickerNo);

    @ApiOperation("新人有礼参加活动")
    @RequestMapping(value = "/join/user", method = RequestMethod.POST)
    public ObjectRestResponse join(@RequestParam(value = "userId",defaultValue ="0" ) Integer userId);

}
