package com.xxfc.platform.activity.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.serializer.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 推广活动（邀请有礼）
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-07-05 15:23:04
 */
@Data
@Table(name = "activity_popularize")
public class ActivityPopularize implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  主键
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键")
    private Integer id;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    /**
     *  更新时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	
	    /**
     *  名称
     */
    @Column(name = "name")
	@ApiModelProperty(value = "名称")
    private String name;
	
	    /**
     *  描述、详情等（看情况使用）
     */
    @Column(name = "descr")
	@ApiModelProperty(value = "描述、详情等（看情况使用）")
    private String descr;
	
	    /**
     *  奖励等 json数组格式 [{"type":1, "detail":{...}},...] //// type分类 1--现金；
     */
    @Column(name = "value")
	@ApiModelProperty(value = "奖励等 json数组格式 [{\"type\":1, \"detail\":{...}},...] //// type分类 1--现金；")
    private String value;
	
	    /**
     *  当前活动的总需进度
     */
    @Column(name = "progress")
	@ApiModelProperty(value = "当前活动的总需进度")
    private Integer progress;
	
	    /**
     *  推广活动类型 1--进度任务型
     */
    @Column(name = "type")
	@ApiModelProperty(value = "推广活动类型 1--进度任务型")
    private Integer type;

	/**
	 *  标记编号 前两位为类型 如 1==01 ；后两位为区分每次活动的编号
	 */
	@Column(name = "code")
	@ApiModelProperty(value = "标记编号 前两位为类型 如 1==01 ；后两位为区分每次活动的编号")
	private String code;

	/**
	 *  活动开始时间
	 */
	@Column(name = "start_time")
	@ApiModelProperty(value = "活动结束时间")
	@JSONField(serializeUsing= ToStringSerializer.class)
	private Long startTime;

	/**
	 *  活动开始时间
	 */
	@Column(name = "end_time")
	@ApiModelProperty(value = "活动结束时间")
	@JSONField(serializeUsing= ToStringSerializer.class)
	private Long endTime;
}
