package com.xinxincaravan.caravan.vehicle.vo;

import com.github.pagehelper.PageInfo;
import lombok.Data;

import java.util.List;

@Data
public  class PageDataVo<T> {
    /**
     * 符合条件记录总数
     */
    private Long totalCount;

    /**
     * 实际数据
     */
    private List<T> data;

    public static <M> PageDataVo<M> pageInfo(PageInfo<M> pageInfo){
        PageDataVo<M> pageDataVo = new PageDataVo<>();
        pageDataVo.setTotalCount(pageInfo.getTotal());
        pageDataVo.setData(pageInfo.getList());
        return pageDataVo;
    }

}
