package com.xinxincaravan.caravan.vehicle.rest;

import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.xinxincaravan.caravan.vehicle.biz.VehicleBiz;
import com.xinxincaravan.caravan.vehicle.biz.VehicleUpkeepService;
import com.xinxincaravan.caravan.vehicle.common.RestResponse;
import com.xinxincaravan.caravan.vehicle.constant.ResCode.ResCode;
import com.xinxincaravan.caravan.vehicle.entity.VehicleUpkeepItem;
import com.xinxincaravan.caravan.vehicle.feign.UserFeign;
import com.xinxincaravan.caravan.vehicle.feign.dto.UserDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("upkeep")
public class VehicleUpkeepController {


    @Autowired
    private VehicleUpkeepService vehicleUpkeepService;
    @Autowired
    VehicleBiz vehicleBiz;

    @Autowired
    UserFeign userFeign;

    @Autowired
    private UserAuthConfig userAuthConfig;
    @Autowired
    protected HttpServletRequest request;

    @GetMapping("item/all")
    public RestResponse allItem() {
        return RestResponse.suc(vehicleUpkeepService.getAllItem());
    }

    @GetMapping("item/page")
    public RestResponse pageItem(Integer page, Integer limit) {
        if (page == null || limit == null) {
            page = 1;
            limit = 10;
        }
        return RestResponse.suc(vehicleUpkeepService.pageItem(page, limit));
    }

    @PostMapping("item")
    public RestResponse addItem(String name) {
        if (name == null || name.trim().equals("")) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        vehicleUpkeepService.addItem(name);
        return RestResponse.suc();
    }

    @PutMapping("item")
    public RestResponse editItem(VehicleUpkeepItem item) {
        if (item == null || item.getId() == null || item.getName() == null || item.getName().trim().equals("")) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        vehicleUpkeepService.updateItem(item);
        return RestResponse.suc();
    }

    @DeleteMapping("item/{id}")
    public RestResponse delItem(@PathVariable("id") Integer id) {
        if (id == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        vehicleUpkeepService.deleteItem(id);
        return RestResponse.suc();
    }

    @GetMapping("log/page")
    public RestResponse pageLog(String numberPlate, Integer page, Integer limit) {
        if (page == null || limit == null) {
            page = 1;
            limit = 10;
        }
        UserDTO userDTO = userFeign.userinfoByToken(userAuthConfig.getToken(request)).getData();
        List<Integer> companyList =new ArrayList<>();
        if (userDTO != null) {
            if (userDTO.getDataAll() == 2) {
                companyList = vehicleBiz.dataCompany(userDTO.getDataZone(), userDTO.getDataCompany());
            }
        }
        return RestResponse.suc(vehicleUpkeepService.pageLog(numberPlate, page, limit,companyList));
    }

    @GetMapping("log/{id}")
    public RestResponse getLog(@PathVariable("id") Integer id) {
        if (id == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        return RestResponse.suc(vehicleUpkeepService.getLogVoById(id));
    }

    @DeleteMapping("log/{id}")
    public RestResponse delLog(@PathVariable("id") Integer id) {
        if (id == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        vehicleUpkeepService.deleteLog(id);
        return RestResponse.suc();
    }

}
