package com.xinxincaravan.caravan.vehicle.rest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.nacos.client.logger.json.JSONArray;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.xinxincaravan.caravan.vehicle.biz.SysRegionBiz;
import com.xinxincaravan.caravan.vehicle.common.BaseController;
import com.xinxincaravan.caravan.vehicle.common.CustomIllegalParamException;
import com.xinxincaravan.caravan.vehicle.common.RestResponse;
import com.xinxincaravan.caravan.vehicle.constant.ConstantType;
import com.xinxincaravan.caravan.vehicle.constant.ResCode.ResCode;
import com.xinxincaravan.caravan.vehicle.entity.Constant;
import com.xinxincaravan.caravan.vehicle.entity.SysRegion;
import com.xinxincaravan.caravan.vehicle.vo.ConstantVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/sysRegion")
@IgnoreClientToken
@Slf4j
public class SysRegionController extends BaseController<SysRegionBiz> {


    @IgnoreUserToken
    @RequestMapping(value ="/sons/{id}",method = RequestMethod.GET)
    public RestResponse<List<SysRegion>> getSonRegion(@PathVariable Long id){
        return RestResponse.data(baseBiz.getSonRegion(id));
    }

    @RequestMapping(value ="",method = RequestMethod.GET)
    public RestResponse<List<SysRegion>> getRegion(@RequestParam String idListJson){
        try {
            List<Long> ids = JSON.parseArray(idListJson,Long.class);
            return RestResponse.data(baseBiz.getRegionsByCodes(ids));
        } catch (JSONException ex) {
            return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
        } catch (CustomIllegalParamException ex){
            return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
        }
    }

}
