package com.xinxincaravan.caravan.vehicle.rest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.xinxincaravan.caravan.vehicle.biz.AccompanyingItemBiz;
import com.xinxincaravan.caravan.vehicle.common.BaseController;
import com.xinxincaravan.caravan.vehicle.common.CustomIllegalParamException;
import com.xinxincaravan.caravan.vehicle.common.RestResponse;
import com.xinxincaravan.caravan.vehicle.constant.ResCode.ResCode;
import com.xinxincaravan.caravan.vehicle.entity.AccompanyingItem;
import com.xinxincaravan.caravan.vehicle.vo.AddOrUpdateAccompanyingItem;
import com.xinxincaravan.caravan.vehicle.vo.PageDataVo;
import com.xinxincaravan.caravan.vehicle.vo.QueryAccompanyItemVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/accompanyingItem")
@IgnoreClientToken
@Slf4j
public class AccompanyingItemController extends BaseController<AccompanyingItemBiz> {

    @RequestMapping(value ="/{id}",method = RequestMethod.GET)
    private RestResponse<AccompanyingItem> get(@PathVariable Integer id) throws Exception{
        return RestResponse.codeAndData(RestResponse.SUC_CODE,baseBiz.get(id));
    }

    @RequestMapping(value ="/all",method = RequestMethod.GET)
    private RestResponse<List<AccompanyingItem>> getAll(){
        return RestResponse.codeAndData(RestResponse.SUC_CODE,baseBiz.getAll());
    }


    @RequestMapping(value ="/page",method = RequestMethod.GET)
    private RestResponse<PageDataVo<AccompanyingItem>> getByPage(@RequestParam String queryAccompanyItemVoJson) throws Exception{
        QueryAccompanyItemVo queryAccompanyItemVo = null;
        try {
            queryAccompanyItemVo = JSON.parseObject(queryAccompanyItemVoJson,QueryAccompanyItemVo.class);
            return RestResponse.data(baseBiz.getByPage(queryAccompanyItemVo));
        } catch (JSONException ex) {
            return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
        } catch (CustomIllegalParamException ex){
            return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
        }
    }

    @RequestMapping(value ="",method = RequestMethod.POST)
    private RestResponse<Integer> add(@RequestBody AddOrUpdateAccompanyingItem addOrUpdateAccompanyingItem) throws Exception{
        return baseBiz.add(addOrUpdateAccompanyingItem);
    }

    @RequestMapping(value ="",method = RequestMethod.PUT)
    private RestResponse<Integer> update(@RequestBody AddOrUpdateAccompanyingItem addOrUpdateAccompanyingItem) throws Exception{
        return baseBiz.update(addOrUpdateAccompanyingItem);
    }

    @RequestMapping(value ="/{id}",method = RequestMethod.DELETE)
    private RestResponse<Integer> del(@PathVariable Integer id) throws Exception{
        return baseBiz.del(id);
    }
}
