package com.xinxincaravan.caravan.vehicle.constant;

import com.google.common.collect.Maps;

import java.util.Map;

public enum AccompanyingItemType {
    TOOL(1,"随车工具"),//这一类型不存在db中，只是用于查询所有国家
    EQUIPMENT(2,"随车配备"),
    EQUIPABLE_ITEM(3,"可配物品"),
    ;

    /**
     * 编码
     */
    private Integer code;
    /**
     * 类型描述
     */
    private String desc;

    private static Map<Integer,String> codeAndDesc = Maps.newHashMap();

    static{
        for(AccompanyingItemType constantType : AccompanyingItemType.values()){
            codeAndDesc.put(constantType.getCode(),constantType.getDesc());
        }
    }

    AccompanyingItemType(Integer code, String desc){
        this.code=code;
        this.desc=desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Boolean exists(Integer code){
        return codeAndDesc.containsKey(code);
    }

}
