package com.github.wxiaoqi.security.admin.rest;

import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.admin.biz.AppUserLoginBiz;
import com.github.wxiaoqi.security.admin.biz.AppUserManageBiz;
import com.github.wxiaoqi.security.admin.constant.Status;
import com.github.wxiaoqi.security.admin.dto.AppUserManageDTO;
import com.github.wxiaoqi.security.admin.entity.AppUserLogin;
import com.github.wxiaoqi.security.admin.entity.AppUserManage;
import com.github.wxiaoqi.security.admin.vo.AppUserManageVo;
import com.github.wxiaoqi.security.admin.vo.AppUserVo;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * app用户管理类
 * @author Administrator
 */
@RestController
@RequestMapping("appUsersManage")
public class AppUsersManageController extends BaseController<AppUserManageBiz,AppUserManage> {

    @Autowired
    private AppUserLoginBiz appUserLoginBiz;

    /**
     * 查询所有
     * @return
     */
    @PostMapping("/findAll")
    public ObjectRestResponse<PageInfo<AppUserManageVo>> findAllByQuery(@RequestBody AppUserManageDTO appUserManageDTO){
        return ObjectRestResponse.succ(baseBiz.findAllByQuery(appUserManageDTO));
    }

    /**
     * 禁用
     * @param id
     * @return
     */
    @DeleteMapping("/deleteById/{id}/{isDel}")
    public  ObjectRestResponse deleteById(@PathVariable Integer id,@PathVariable Integer isDel){
        baseBiz.deleteAppUser(id,isDel);
        return ObjectRestResponse.succ();
    }

    /**
     * 查询一条
     * @param id
     * @return
     */
    @GetMapping("/findOneById/{id}")
    public ObjectRestResponse<AppUserVo> findOneById(@PathVariable Integer id){
        return ObjectRestResponse.succ(baseBiz.findOneById(id));
    }

    /**
     * 保存
     * @param appUserVo
     * @return
     */
    @PostMapping("/save")
    public ObjectRestResponse save(@RequestBody AppUserVo  appUserVo){
        baseBiz.save(appUserVo);
        return ObjectRestResponse.succ();
    }

    /**
     * 禁用
     * @param appUserId
     * @return
     */
    @PutMapping("/disable/{appUserId}")
    public ObjectRestResponse disable(@PathVariable("appUserId") Integer appUserId){
        AppUserLogin appUserLogin = new AppUserLogin();
        appUserLogin.setStatus(Status.FORBIDDEN);
        appUserLogin.setId(appUserId);
        appUserLoginBiz.disable(appUserLogin);
        return ObjectRestResponse.succ();
    }

    /**
     * 取消禁用
     * @param appUserId
     * @return
     */
    @PutMapping("/available/{appUserId}")
    public ObjectRestResponse available(@PathVariable("appUserId") Integer appUserId){
        AppUserLogin appUserLogin = new AppUserLogin();
        appUserLogin.setStatus(Status.AVAILABLE);
        appUserLogin.setId(appUserId);
        appUserLoginBiz.available(appUserLogin);
        return ObjectRestResponse.succ();
    }


}

