package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.vo.InviteMemberVo;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.auth.client.jwt.UserAuthUtil;
import com.github.wxiaoqi.security.auth.common.util.jwt.IJWTInfo;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.admin.biz.AppUserRelationBiz;
import com.github.wxiaoqi.security.admin.entity.AppUserRelation;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

@RestController
@RequestMapping("relation")
public class AppUserRelationController extends BaseController<AppUserRelationBiz,AppUserRelation> {

    @Autowired
    private UserAuthUtil userAuthUtil;

    @Autowired
    private UserAuthConfig userAuthConfig;


    @RequestMapping(value = "app/unauth/small/share",method = RequestMethod.GET)
    @ApiModelProperty("小程序分享绑定")
    public ObjectRestResponse share(
            @RequestParam(value = "userid",defaultValue = "0")Integer userid,
            @RequestParam(value = "pid",defaultValue = "0")Integer pid,
            @RequestParam(value = "platform_userid",defaultValue = "0")Integer platform_userid
    ){
        return baseBiz.shareParentByUserId(userid,pid,platform_userid);
    }

     @ApiOperation("查询邀请的成员")
    @GetMapping("/pages")
    public ObjectRestResponse<InviteMemberVo> findInviteMemberByActivitState(@RequestParam(value = "state",required = false) Integer state,
                                                                             @RequestParam("page") Integer page,
                                                                             @RequestParam("limit") Integer limit,
                                                                             HttpServletRequest request){
        try {
            IJWTInfo infoFromToken = userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request));
            InviteMemberVo inviteMemberVo =  baseBiz.findInviteMemberByActivitState(Integer.valueOf(infoFromToken.getId()),state,page,limit);
          return ObjectRestResponse.succ(inviteMemberVo);
        } catch (Exception e) {
            throw new BaseException(e);
        }
    }

}