package com.github.wxiaoqi.security.admin.biz;

import com.github.wxiaoqi.security.admin.bo.PromoteBO;
import com.github.wxiaoqi.security.admin.bo.UserTeamMemberBo;
import com.github.wxiaoqi.security.admin.entity.AppUserDetail;
import com.github.wxiaoqi.security.admin.entity.AppUserLogin;
import com.github.wxiaoqi.security.admin.entity.AppUserRelation;
import com.github.wxiaoqi.security.admin.vo.UserTeamMemberVo;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/11 14:44
 */
@Transactional
@Service
public class UserBusinessBiz {

    @Autowired
    private AppUserRelationBiz appUserRelationBiz;

    @Autowired
    private AppUserSellingWaterBiz appUserSellingWaterBiz;

    @Autowired
    private AppUserLoginBiz appUserLoginBiz;

    @Autowired
    private AppUserDetailBiz appUserDetailBiz;

    public UserTeamMemberVo findTeamMemberPageByUserId(Integer userId, Integer pageNo, Integer pageSize) {

         UserTeamMemberVo userTeamMemberVo  = new UserTeamMemberVo();
        //根据用户id去关系表里查询下级
        PageDataVO<AppUserRelation> memberPage = appUserRelationBiz.findMemberPageByLeaderId(userId, pageNo, pageSize);

        List<AppUserRelation> teamMemberBos = memberPage.getData();
        if (CollectionUtils.isEmpty(teamMemberBos)) {
            return userTeamMemberVo;
        }

        List<Integer> memberIds = teamMemberBos.stream().map(team -> team.getUserId()).collect(Collectors.toList());
        Map<Integer, BigDecimal> memberIdAndIncomeMap = appUserSellingWaterBiz.findMemberIdAndIncomeMapByMemberIds(memberIds);
        if (memberIdAndIncomeMap == null) {
            return userTeamMemberVo;
        }

        Map<Integer,AppUserLogin> userIdAndAppUserLoginMap = appUserLoginBiz.findUserIdAndUserLoginMapByMemberIds(memberIds);
        Map<Integer, AppUserDetail> userIdAndAppUserDetailMap  = appUserDetailBiz.findUserIdAndUserDetailMapByMemberIds(memberIds);

        List<UserTeamMemberBo> userTeamMemberBos = new ArrayList<>();
        UserTeamMemberBo userTeamMemberBo;
        BigDecimal totalIncome = new BigDecimal(0);
        for (AppUserRelation appUserRelation : teamMemberBos) {

            userTeamMemberBo = new UserTeamMemberBo();
            userTeamMemberBo.setLeagueTime(appUserRelation.getBindTime());
            userTeamMemberBo.setUserId(appUserRelation.getUserId());

            if (userIdAndAppUserLoginMap!=null){
                AppUserLogin appUserLogin = userIdAndAppUserLoginMap.get(appUserRelation.getUserId());
                userTeamMemberBo.setUserName(appUserLogin.getUsername());
            }
            if (userIdAndAppUserDetailMap!=null){
                AppUserDetail appUserDetail = userIdAndAppUserDetailMap.get(appUserRelation.getUserId());
                userTeamMemberBo.setHeadUrl(appUserDetail==null?"":appUserDetail.getHeadimgurl());
                userTeamMemberBo.setNickName(appUserDetail==null?"":appUserDetail.getNickname());
            }
            userTeamMemberBo.setIncome(memberIdAndIncomeMap.get(appUserRelation.getUserId()));
            totalIncome = totalIncome.add(userTeamMemberBo.getIncome());
            userTeamMemberBos.add(userTeamMemberBo);
        }
        userTeamMemberVo.setPageNum(memberPage.getPageNum());
        userTeamMemberVo.setPageSize(memberPage.getPageSize());
        userTeamMemberVo.setTotalCount(memberPage.getTotalCount().intValue());
        userTeamMemberVo.setTotalPage(memberPage.getTotalPage());
        userTeamMemberVo.setUserTeamMemberBos(userTeamMemberBos);
        userTeamMemberVo.setTotalIncome(totalIncome);
        return userTeamMemberVo;
    }

    public PromoteBO getPromoteBoByUserId(Integer  userId) {

        PromoteBO promoteBO = new PromoteBO();
        Integer leaderId =  appUserRelationBiz.findLeaderIdByMemberId(userId);
        Map<Integer,Integer> memberStateAndCountMap = appUserRelationBiz.findMemberSateAndCountMapByLeaderId(userId);

        if (leaderId != 0) {
            Map<Integer, AppUserLogin> userIdAndUserLoginMap = appUserLoginBiz.findUserIdAndUserLoginMapByMemberIds(Arrays.asList(leaderId));
            Map<Integer, AppUserDetail> userIdAndUserDetailMap = appUserDetailBiz.findUserIdAndUserDetailMapByMemberIds(Arrays.asList(leaderId));
            promoteBO.setLeaderUsername(userIdAndUserLoginMap.get(leaderId).getUsername());
            promoteBO.setLeaderHeadUrl(userIdAndUserDetailMap.get(leaderId).getHeadimgurl());
        }
        promoteBO.setInviteNumber(memberStateAndCountMap.get(0));
        promoteBO.setActivatedNumber(memberStateAndCountMap.get(1));

        BigDecimal totalIncome = appUserSellingWaterBiz.selectTotalIncomeByUserId(userId);
        promoteBO.setTotalIncome(totalIncome==null?new BigDecimal(0):totalIncome);
        return promoteBO;
    }
}
