package com.github.wxiaoqi.security.common.handler;


import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.BaseResponse;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice("com.xxfc.platform")
public class PlatformExceptionHandler {

    @ExceptionHandler(value = {BaseException.class})
    public BaseResponse baseExceptionHandler(Exception e) {
        if (e instanceof BaseException){
             BaseException be = (BaseException) e;
            return new BaseResponse(be.getStatus(), be.getMessage());
        }
        return new BaseResponse(400,e.getMessage());
    }

}
