/*
 * Decompiled with CFR 0.152.
 */
package ytx.org.apache.http.protocol;

import java.io.IOException;
import ytx.org.apache.http.HttpException;
import ytx.org.apache.http.HttpRequest;
import ytx.org.apache.http.HttpRequestInterceptor;
import ytx.org.apache.http.annotation.Immutable;
import ytx.org.apache.http.params.HttpProtocolParams;
import ytx.org.apache.http.protocol.HttpContext;

@Immutable
public class RequestUserAgent
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        String useragent;
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (!request.containsHeader("User-Agent") && (useragent = HttpProtocolParams.getUserAgent(request.getParams())) != null) {
            request.addHeader("User-Agent", useragent);
        }
    }
}

